#
# Copyright (c) 2013 The Linux Foundation. All rights reserved.
# Copyright (C) 2006-2011 OpenWrt.org
#
# This is free software, licensed under the GNU General Public License v2.
# See /LICENSE for more information.
#

KERNEL_MAKEOPTS := -C $(RTOS_DIR)

# KERNEL_MAKEOPTS += CROSS_COMPILE="$(KERNEL_CROSS)" \
# 	HOSTCFLAGS="$(HOST_CFLAGS) -Wall -Wmissing-prototypes -Wstrict-prototypes" \
# 	ARCH="$(RTOS_KARCH)" \
# 	KBUILD_HAVE_NLS=no \
# 	CONFIG_SHELL="$(BASH)" \
# 	$(if $(findstring c,$(OPENWRT_VERBOSE)),V=1,V='')

# Kernel compiles well in parallel
# Enable // build if selected in the menuconfig
ifneq ($(CONFIG_PKG_BUILD_USE_JOBSERVER)$(MAKE_JOBSERVER),)
  ifeq ($(MAKE_JOBSERVER),)
    KERNEL_JFLAG ?= -j1
  else
    KERNEL_JFLAG ?= $(MAKE_JOBSERVER) -j
  endif
else
  KERNEL_JFLAG ?= $(if $(CONFIG_PKG_BUILD_JOBS),-j$(CONFIG_PKG_BUILD_JOBS),-j1)
endif

ifneq (,$(KERNEL_CC))
  KERNEL_MAKEOPTS += CC="$(KERNEL_CC)"
endif

T_KERNEL_CONFIG := $(T_PRODUCT_CONFIG_DIR)/$(PR_NAME)/kernel.config

define Kernel/Prepare/Default
	mkdir -p $(RTOS_DIR)
	$(CP) $(CONFIG_EXTERNAL_KERNEL_TREE)/* $(RTOS_DIR)/
endef

define Kernel/Configure/Default
	@if [ \! -n $(PR_NAME) ]; then \
		echo "ERROR:PR_NAME NOT specified "; \
		exit 1; \
	fi
	@if [ \! -e $(T_KERNEL_CONFIG) ]; then \
		echo "ERROR:file $(T_KERNEL_CONFIG) was NOT found "; \
		exit 1; \
	fi
	cp $(T_KERNEL_CONFIG) $(RTOS_DIR)/.config
	+$(MAKE) $(KERNEL_MAKEOPTS) savemenuconfig
endef

define Kernel/CompileModules/Default
	rm -rf $(RTOS_DIR)/out/*
	+$(MAKE) $(KERNEL_MAKEOPTS) $(KERNEL_JFLAG)
endef

define Kernel/CompileImage/Extract_Libraries
	@for library in `find $(KERNEL_BUILD_DIR)/libraries/ -name "*.a"`; \
	do \
		dir=`dirname $$$$library`; \
		library_name=`basename $$$$library`; \
		base_name=`basename $$$$library .a`; \
		echo "library_name = $$$$library_name base_name = $$$$base_name";\
		cd $$$$dir;\
		if [ "$$$$dir" == "$(KERNEL_BUILD_DIR)/libraries/mpp" ]; then \
			if [[ "$$$$library_name" == lib* ]]; then \
				MPP_LIB=`echo $$$$base_name | sed 's/^lib//g'` \
				MPP_LIBS=$$$${MPP_LIBS}" -l$$$${MPP_LIB}"; \
				echo "$$$${MPP_LIBS}" > $(KERNEL_BUILD_DIR)/libraries/mpp_ld.text; \
			else \
				$(KERNEL_CROSS)ar -x $$$$library_name; \
				cd ../../; \
			fi \
		else \
			if [ ! -d $$$$base_name ]; \
			then \
			mkdir -p $$$$base_name; \
			fi; \
			cd $$$$base_name; \
			$(KERNEL_CROSS)ar -x ../$$$$library_name; \
			cd ../../../; \
		fi \
	done
endef

define Kernel/Clean/Default
	rm -f $(KERNEL_BUILD_DIR)/rtos-$(RTOS_VERSION)/.configured
	$(_SINGLE)$(MAKE) -C $(KERNEL_BUILD_DIR)/rtos-$(RTOS_VERSION) clean
endef


